package examples;

import javax.swing.*;

public class Throwing {
	private static final int START_YEAR_INDEX = 6;
	private static final int END_YEAR_INDEX = 10;

	public static void main(String[] args) {
		String date = "";
		try {
			date = JOptionPane.showInputDialog("Enter date using format: (mm/dd/yyyy)");

			/* substring may throw IndexOutOfBoundsException */
			String yearString = date.substring(START_YEAR_INDEX, END_YEAR_INDEX);

			/* parseInt may throw NumberFormatException */
			int year = Integer.parseInt(yearString);

			if (year > 2015)
				throw new Exception("Year cannot exceed 2015");

			System.out.println("The year is " + year);

		} catch (IndexOutOfBoundsException e) {
			System.out.println("Index error");
		} catch (NumberFormatException e) {
			System.out.println("Number format exception");
		} catch (Exception e) {
			System.out.println(e.getMessage());
		} finally {
			System.out.println("The original string: " + date);
		}
	}
}